


 /**
 ******************************************************************************
 *
 * @file        USBD_DSC.h
 * @brief       The USBD Descriptor's h file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2020/09/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _USB_DSC_H
#define _USB_DSC_H

#include "MG32.h"
#include "MG32_USB_Init.h"

/**
 * @name USB Class Codes
 *   		
 */ 
///@{

//--------------------------------------------------------------------------------
//Defined Class Codes (USB-IF Last Update: January 7, 2022)
#define bDeviceClass_InterfaceDescriptors          0x00         /*!< Use class information in the Interface Descriptors.*/
#define bDeviceClass_CDC                           0x02         /*!< Communications and CDC Control.*/      
#define bDeviceClass_Hub                           0x09
#define bDeviceClass_BillboardDeviceClass          0x11
#define bDeviceClass_DiagnosticDevice              0xDC
#define bDeviceClass_Miscellaneous                 0xEF
#define bDeviceClass_VendorSpecific                0xFF

//-------------------------------------------------------------------------------- 
//Defined Class Codes (USB-IF Last Update: January 7, 2022)                            
#define bInterfaceClass_Audio                      0x01
#define bInterfaceClass_CDC                        0x02         /*!< Communications and CDC Control.*/      
#define bInterfaceClass_HID                        0x03         /*!< HID(Human Interface Device).*/
#define bInterfaceClass_Physical                   0x05
#define bInterfaceClass_Image                      0x06
#define bInterfaceClass_Printer                    0x07
#define bInterfaceClass_MassStorage                0x08
#define bInterfaceClass_CDCData                    0x0A
#define bInterfaceClass_SmartCard                  0x0B
#define bInterfaceClass_ContentSecurity            0x0D
#define bInterfaceClass_Video                      0x0E
#define bInterfaceClass_PersonalHealthcare         0x0F
#define bInterfaceClass_AudioVideoDevices          0x10
#define bInterfaceClass_USBTypeC_BridgeClass       0x12
#define bInterfaceClass_I3CDeviceClass             0x3C
#define bInterfaceClass_DiagnosticDevice           0xDC
#define bInterfaceClass_WirelessController         0xE0
#define bInterfaceClass_Miscellaneous              0xEF
#define bInterfaceClass_ApplicationSpecific        0xFE
#define bInterfaceClass_VendorSpecific             0xFF 

///@}

/**
 * @name  consumer define
 */
///@{ 

#define    HID_REPORT_LENGTH sizeof(HID_REPORT)



#define    EP0_PACKET_SIZE       64                                       /*!< Maximum packet size for EP0.*/
#define    EP1_PACKET_SIZE       64                                       /*!< Maximum packet size for EP1.*/
#define    EP2_PACKET_SIZE       8                                        /*!< Maximum packet size for EP2.*/                                  





#define USB_CONFIGURATION_DESC_SIZE        9          /*!< USB Configuration descriptor data size. */
#define USB_INTERFACE_DESC_SIZE            9          /*!< USB Interface descriptor data size. */
#define USB_HID_DESC_SIZE                  9          /*!< USB HID descriptor data size. */
#define USB_ENDPOINT_DESC_SIZE             7          /*!< USB Endpoint descriptor data size. */


#define USB_CONFIGURATION_TOTAOL_INTERFACE  2                                                                                    /*!< Total interface in the configuration.*/

#define USB_CONFIGURATION_DESC_TOTAOSIZE   ((USB_CONFIGURATION_DESC_SIZE * 1) +  \
                                            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE + USB_ENDPOINT_DESC_SIZE * 1) + \
                                            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE + USB_ENDPOINT_DESC_SIZE * 2))          /*!< The configuration descriptor total size.*/
         


       
extern const uint16_t HID0_ReportLength;                    /*!< HID0 report size */
extern const uint16_t HID1_ReportLength;                    /*!< HID1 report size */

extern const uint8_t USB_INTERFACE0_HID_REPORT[];           /*!< HID report of interface0.*/
extern const uint8_t USB_INTERFACE1_HID_REPORT[];           /*!< HID report of interface1.*/
extern const uint8_t USB_DEVICE_DESCRIPTOR[];               /*!< Device Descriptor.*/
extern const uint8_t USB_CONGFIGURATION_DESCRIPTOR[];       /*!< Configuration Descriptor.*/
extern const uint8_t USB_STRING_DESCRIPTOR[];               /*!< String descriptor.*/
                                                            
#if MF_STRING == 1                                          
#define MFS_LEN (sizeof(MANUFACTURER_DESCRIPTOR)*2)         /*!< Manufacture descriptor size.*/
extern  const uint8_t Manufacturer_Descriptor[];            /*!< Manufacture string descriptor.*/
#endif                                                      
                                                            
#if PD_STRING == 1                                          
#define PDS_LEN (sizeof(PRODUCT_DESCRIPTOR)*2)              /*!< Product descriptor size.*/
extern const uint8_t Product_Descriptor[];                  /*!< Product string descriptor.*/
#endif                                                      
                                                            
#if SN_STRING == 1                                          
#define SNS_LEN (sizeof(SERIALNUMBER_DESCRIPTOR)*2)         /*!< Serial number descriptor size.*/
extern const uint8_t SerialNumber_Descriptor[];             /*!< Serial number string descriptor.*/
#endif                                                      
                                                            
#if MG_USB_LPM_EN == 1                                      
extern const uint8_t USB_BOS_DESCRIPTOR[];                  /*!< BOS descriptor.*/
extern const uint8_t USB_EXT_DESCRIPTOR[];                  /*!< Device capabilty descriptor.*/
#endif


///@}



#endif
















